// mem.c:	custom memory functions
#include <windows.h>
#include <windowsx.h>
#include <assert.h>
#include <string.h>
#include "msx.h"

static const char BASED_CODE	szMemory[] = 
	"Out of memory. Close other applications and try again." ;
extern const char	g_szAppName[] ;
extern HWND		g_hwndMain ;

void MemoryAlert ()
	{
	MessageBox (g_hwndMain, szMemory, g_szAppName, MB_ICONSTOP) ;
	}

BOOL NewGlobal (void FAR** ppv, UINT uFlags, DWORD dwSize)
	{
	BYTE	FAR *pnew ;
	
	assert (dwSize != 0) ;
	assert (uFlags != 0) ;	// then it would be fixed, which we do not require
	
	pnew = GlobalAllocPtr (uFlags, dwSize) ;
	
	if (pnew != NULL)
		{
		*ppv = pnew ;
		return TRUE ;
		}
	else 
		{
		MemoryAlert () ;
		return FALSE ;
		}
	}

void FreeGlobal (void FAR** ppv)
	{
	assert (*ppv != NULL) ;
	
	GlobalFreePtr (*ppv) ;
	*ppv = NULL ;
	}

BOOL SizeGlobal (void FAR** ppv, DWORD dwSize)
	{
	void FAR*	pv ;
	
	assert (*ppv != NULL) ;
	
	pv = GlobalReAllocPtr (*ppv, dwSize, GMEM_ZEROINIT) ;
	
	if (pv != NULL)
		{
		*ppv = pv ;
		return TRUE ;
		}
	else
		{
		MemoryAlert () ;
		return FALSE ;
		}
	}

BOOL NewLocal (void **ppv, UINT uFlags, UINT	uSize)
	{
	void *pnew ;
	
	assert (uSize != 0) ;
	
	pnew = (void*)LocalAlloc (uFlags, uSize) ;
	
	if (pnew != NULL)
		{
		*ppv = pnew ;
		return TRUE ;
		}
	else 
		{
		MemoryAlert () ;
		return FALSE ;
		}
	}

void FreeLocal (void **ppv)
	{
	assert (*ppv != NULL) ;
	
	LocalFree ((HLOCAL)*ppv) ;
	*ppv = NULL ;
	}

HLOCAL LocalReAlloc2 (HLOCAL hLoc, UINT nNewSize, UINT wFlags)
	{
	HLOCAL	hLocal ;
	UINT		nSize ;
	
	assert (hLoc != NULL) ;
	
	nSize = LocalSize (hLoc) ;
	hLocal = LocalAlloc (wFlags, nNewSize) ;
	assert (hLocal != NULL) ;
	
	memcpy ((void*)hLocal, (void*)hLoc, nSize) ;
	
	assert (LocalFree (hLoc) == NULL) ;
	
	return hLocal ;
	}

BOOL SizeLocal (void **ppv, UINT uSize)
	{
	void *pv ;
	
	assert (*ppv != NULL) ;
	
	pv = (void*)LocalReAlloc2 ((HLOCAL)*ppv, uSize, LMEM_ZEROINIT) ;
	
	if (pv != NULL)
		{
		*ppv = pv ;
		return TRUE ;
		}
	else
		{
		MemoryAlert () ;
		return FALSE ;
		}
	}
