; IO.ASM : memory and I/O emulation

	.model medium
	.386

; variables

EXTRN 		_regSP:WORD, _regPC:WORD, _lpVideoMem:DWORD, _bScrModified:WORD
EXTRN		_g_bCaps:WORD, _g_byScanLines:BYTE, _Patch:FAR, _regAF:WORD
EXTRN		fIFF:BYTE, _Joy1:FAR, _Joy2:FAR, _PrintCode:FAR
PUBLIC		_MemTbl, _Reset, ReadMemTbl, WriteMemTbl
PUBLIC		_ROMTbl, _lpCartA, _lpCartB, _byMegaSizeA, _byMegaSizeB
PUBLIC		_WriteMem, ReadIO, WriteIO, _PSGReg, _ResetMega
PUBLIC		PushVal, PopVal, VDPReg, _WriteMemW

.data

VDPReg		DB		9 DUP (?)
VDPRegMask	DB		2, 07bh, 0fh, 0ffh, 7, 07fh, 7, 0ffh
FirstByte		DB		?
IsFirst		DB		?
WriteAddress	DW		?
ReadAddress	DW		?

_PSGReg		DB		16 DUP (?)
PSGRegCur		DB		?
PSGRegMask	DB		0ffh, 0fh, 0ffh, 0fh, 0ffh, 0fh, 01fh, 0ffh
			DB		01fh, 01fh, 01fh, 0ffh, 0ffh, 0fh, 0, 0ffh

OldPrnState	DB		?
PrnCode		DB		?

ReadMemTbl	DD		8 DUP(?)
WriteMemTbl	DW		4 DUP(?)
MegaTblA		DB		4 DUP(?)
MegaTblB		DB		4 DUP(?)

PPIregC		DB		?
PPIregA		DB		?

_MemTbl		DD		16 DUP(0)
_ROMTbl		DB		16 DUP(0)
_lpCartA		DD		?
_byMegaSizeA	DB		?
_lpCartB		DD		?
_byMegaSizeB	DB		?

.code

_WriteMem		PROC		NEAR
		mov		bl, ch
		shr		bl, 5
		and		bx, 110b
		mov		bx, WriteMemTbl[bx]
		xchg		bx, cx
		cmp		cx, 3
		jbe		SHORT WriteMegaROM
		mov		es, cx
		mov		es:[bx], dh
		retn

WriteMegaROM:
		jcxz		ROM
		cmp		cx, 3
		je		SHORT WriteGMaster2
		test		bx, 0fffh
		jnz		SHORT ROM
		cmp		bx, 4000h
		je		short ROM
		cmp		cx, 2
		je		SHORT WriteMegaROMB
		push		ax
		and		dh, _byMegaSizeA
		rol		bx, 5
		and		bx, 11100b
		mov		cx, WORD PTR _lpCartA + 2
		mov		al, dh
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl[bx] + 2, cx
		mov		ch, dh
		shl		ch, 5
		and		cx, 0e000h
		mov		WORD PTR ReadMemTbl[bx] + 0, cx
		shr		bx, 2
		and		bx, 3
		mov		MegaTblA[bx], dh
		pop		ax
ROM:
		retn

WriteMegaROMB:
		push		ax
		and		dh, _byMegaSizeB
		rol		bx, 5
		and		bx, 11100b
		mov		cx, WORD PTR _lpCartB + 2
		mov		al, dh
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl[bx] + 2, cx
		mov		ch, dh
		shl		ch, 5
		and		cx, 0e000h
		mov		WORD PTR ReadMemTbl[bx] + 0, cx
		shr		bx, 2
		and		bx, 3
		mov		MegaTblB[bx], dh
		pop		ax
		retn

WriteGMaster2		PROC 	NEAR
		cmp		bx, 0a000h
		ja		SHORT WriteSRAM
		jb		SHORT WriteGBank
		test		dh, 010h
		je		SHORT WriteGBank
		test		dh, 020h
		setnz	dh
		add		dh, 010h
		jmp		SHORT WriteGBank2
WriteGBank:
		and		dh, 15
WriteGBank2:
		test		bx, 01FFFh
		jne		SHORT NoSRAM
		push		ax
		rol		bx, 5
		and		bx, 11100b
		mov		cx, WORD PTR _lpCartA + 2
		mov		al, dh
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl[bx] + 2, cx
		mov		ch, dh
		shl		ch, 5
		and		cx, 0e000h
		mov		WORD PTR ReadMemTbl[bx] + 0, cx
		shr		bx, 2
		and		bx, 3
		mov		MegaTblA[bx], dh
		pop		ax
		retn

WriteSRAM:
		cmp		MegaTblA + 1, 010h
		jb		SHORT NoSRAM
		mov		cx, WORD PTR _lpCartA + 2
		add		cx, 16
		mov		es, cx
		and		bx, 01fffh
		mov		cx, 0
		cmp		MegaTblA + 1, 010h
		je		SHORT Not1
		mov		cx, 02000h
Not1:	or		bx, cx
		mov		es:[bx], dh
NoSRAM:
		retn
WriteGMaster2	ENDP

_WriteMem		ENDP

PushVal		PROC		NEAR
		sub		_regSP, 2
		mov		cx, _regSP
_WriteMemW	PROC		NEAR
		mov		bl, ch
		shr		bl, 5
		and		bx, 110b
		mov		bx, WriteMemTbl[bx]
		xchg		bx, cx
		cmp		cx, 3
		jbe		SHORT ROM2
		mov		es, cx
		mov		es:[bx], dx
NoGMaster2:
		ret
ROM2:
		jne		NoGMaster2
		push		dx
		push		bx
		mov		dh, dl
		call		WriteGMaster2
		pop		bx
		inc		bx
		pop		dx
		jmp		WriteGMaster2
_WriteMemW	ENDP
PushVal		ENDP		

PopVal		PROC		NEAR
		mov		cx, _regSP
		add		_regSP, 2
		mov		bx, cx
		rol		bx, 5
		and		bx, 11100b
		les		bx, ReadMemTbl[bx]
		and		ch, 01fh
		or		bx, cx
		mov		dx, es:[bx]
		ret
PopVal		ENDP

ReadIO		PROC		NEAR
		; Port in dl, data in dh
		cmp       dl, 0abh
		ja		SHORT Readxx
		sub		dl, 088h
		jb		SHORT Readxx
		movzx	ebx, dl
		jmp		cs:ReadIOjmp[ebx*2]

Readxx:
		mov		dh, 0ffh
		ret
		
ReadIOjmp		DW	Read98, Read99, Readxx, Readxx	; 88 thru 8b
			DW	Readxx, Readxx, Readxx, Readxx	; 8c thru 8f
			DW	Read90, Readxx, Readxx, Readxx	; 90 thru 93
			DW	Readxx, Readxx, Readxx, Readxx	; 94 thru 97
			DW	Read98, Read99, Readxx, Readxx	; 98 thru 9b
			DW	Readxx, Readxx, Readxx, Readxx	; 9c thru 9f
			DW	Reada2, Readxx, Reada2, Readxx	; a0 thru a3
			DW	Reada2, Readxx, Reada2, Readxx	; a4 thru a7
			DW	Reada8, Reada9, Readaa, Readxx	; a8 thru ab

Read90:
		mov		dh, 253
		ret

Read98:
		mov		es, WORD PTR _lpVideoMem + 2
		mov		bx, ReadAddress
		mov		dh, es:[bx]
		inc		bx
		and		bh, 03Fh
		mov		ReadAddress, bx
		mov		IsFirst, 0
		ret

Read99:
		mov		dh, VDPReg + 8
		and		VDPReg + 8, 07Fh
		mov		IsFirst, 0
		ret

Readaa:	mov		dh, PPIregC
		ret

Reada2:
		mov		bl, PSGRegCur
		and		bx, 15
		cmp		bl, 14
		jz		SHORT Joystick
		mov		dh, _PSGReg[bx]
		ret
Joystick:
		test		_PSGReg[15], 040h
		jnz		SHORT Joy2
		push		ax
		call		_Joy1
		mov		dh, al
		pop		ax
		ret
Joy2:
		push		ax
		call		_Joy2
		mov		dh, al
		pop		ax
		ret

Reada8:	
		mov		dh, PPIregA
		ret

Reada9:
		mov		bl, PPIregC
		and		bx, 15
		cmp		bl, 8
		ja		SHORT NoScanLine
		mov		dh, _g_byScanLines[bx]
		not		dh
		ret
NoScanLine:
		mov		dh, 0ffh
		ret

ReadIO		ENDP

WriteIO		PROC		NEAR
		; Port in dl, data in dh
		cmp       dl, 0d0h
		ja		SHORT Writexx
		sub		dl, 088h
		jb		SHORT Writexx
		movzx	ebx, dl
		jmp		cs:WriteIOjmp[ebx*2]
Writexx:
		ret

WriteIOjmp	DW	Write98, Write99, Writexx, Writexx	; 88 thru 8b
			DW	Writexx, Writexx, Writexx, Writexx	; 8c	thru 8f
			DW	Write90, Write91, Writexx, Writexx ; 90 thru 93
			DW	Writexx, Writexx, Writexx, Writexx	; 94	thru 97
			DW	Write98, Write99, Writexx, Writexx	; 98 thru 9b
			DW	Writexx, Writexx, Writexx, Writexx	; 9c	thru 9f
			DW	Writea0, Writea1, Writea0, Writea1	; a0	thru a3
			DW	Writea0, Writea1, Writea0, Writea1	; a4	thru a7
			DW	Writea8, Writexx, Writeaa, Writeab	; a8	thru ab
			DW	Writexx, Writexx, Writexx, Writexx	; ac	thru af
			DW	Writexx, Writexx, Writexx, Writexx	; b0	thru b3
			DW	Writexx, Writexx, Writexx, Writexx	; b4	thru b7
			DW	Writexx, Writexx, Writexx, Writexx	; b8	thru bb
			DW	Writexx, Writexx, Writexx, Writexx	; bc	thru bf
			DW	Writexx, Writexx, Writexx, Writexx	; c0	thru c3
			DW	Writexx, Writexx, Writexx, Writexx	; c4	thru c7
			DW	Writexx, Writexx, Writexx, Writexx	; c8	thru cb
			DW	Writexx, Writexx, Writexx, Writexx	; cc	thru cf
			DW	Writed0                            ; d0

Write90:
		test		dh, 2
		jnz		SHORT NotPrint
		test		OldPrnState, 2
		jz		SHORT NotPrint
		mov		OldPrnState, dh
		push		ax
		movzx	ax, PrnCode
		push		ax
		call		_PrintCode
		add		sp, 2
		pop		ax
		ret
NotPrint:
		mov		OldPrnState, dh
		ret

Write91:
		mov		PrnCode, dh
		ret

Writeab:
		mov		cl, dh
		shr		cl, 1
		and		cl, 111b
		mov		dl, PPIregC
		mov		ch, NOT 1
		rol		ch, cl
		and		dl, ch
		and		dh, 1
		shl		dh, cl
		or		dh, dl
Writeaa:
		mov		PPIregC, dh
		test		dh, 040h
		setz		cl
		sub		ch, ch
		mov		_g_bCaps, cx
		ret

Writea0:
		mov		PSGRegCur, dh
		ret

Writea1:
		mov		bl, PSGRegCur
		and		bx, 15
		and		dh, PSGRegMask[bx]
		mov		_PSGReg[bx], dh
		ret

Write98:
		mov		es, WORD PTR _lpVideoMem + 2
		mov		bx, WriteAddress
		mov		es:[bx], dh
		inc		bx
		and		bh, 03Fh
		mov		WriteAddress, bx
		mov		_bScrModified, 1
		mov		IsFirst, 0
		ret

Write99:
		cmp		IsFirst, 0
		jnz		SHORT Second
		mov		FirstByte, dh
		mov		IsFirst, 1
		ret
Second:
		mov		IsFirst, 0
		test		dh, 080h
		jnz		SHORT Register
		test		dh, 040h
		jnz		SHORT Write
		mov		dl, FirstByte
		and		dh, 03Fh
		mov		ReadAddress, dx
		ret
Write:
		mov		dl, FirstByte
		and		dh, 03Fh
		mov		WriteAddress, dx
		ret
Register:
		mov		bl, dh
		and		bx, 111b
		mov		dl, FirstByte
		; filter out the crap dumb people put into it
		and		dl, VDPRegMask[bx]
		mov		VDPReg[bx], dl
		mov		_bScrModified, 1
		ret
		
Writea8:
		cmp		PPIregA, dh
		jnz		SHORT ProWritea8
		ret
ProWritea8	PROC 	NEAR
		push		eax
		mov		PPIregA, dh
		mov		bl, dh
		shl		bx, 2
		and		bx, 1100b
		mov		eax, _MemTbl[bx]
		mov		ecx, eax
		shr		ecx, 16
		shr		bx, 2
		cmp		_ROMTbl[bx], 0
		jz		$+4
		sub		cx, cx
		mov		ReadMemTbl, eax
		add		eax, 02000h ;
		mov		ReadMemTbl + 4, eax
		mov		WriteMemTbl, cx
page1:
		mov		bl, dh
		and		bx, 1100b
		mov		eax, _MemTbl+16[bx]
		mov		ecx, eax
		shr		ecx, 16
		jcxz		page1megaA
		cmp		cx, 2
		je		SHORT page1megaA
		cmp		cx, 1
		je		SHORT page1megaB
		shr		bx, 2
		cmp		_ROMTbl+4[bx], 0
		jz		$+4
		sub		cx, cx
		mov		ReadMemTbl + 8, eax
		add		eax, 02000h ;
		mov		ReadMemTbl + 12, eax
		mov		WriteMemTbl + 2, cx
		jmp		short page2
page1megaA:
		inc		cx
		mov		WriteMemTbl + 2, cx
		mov		cx, WORD PTR _lpCartA + 2
		mov		al, MegaTblA + 2
		mov		bl, al
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl + 8 + 2, cx
		and		bx, 7
		ror		bx, 3
		mov		WORD PTR ReadMemTbl + 8 + 0, bx
		mov		cx, WORD PTR _lpCartA + 2
		mov		al, MegaTblA + 3
		mov		bl, al
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl + 8 + 6, cx
		and		bx, 7
		ror		bx, 3
		mov		WORD PTR ReadMemTbl + 8 + 4, bx
		jmp		short page2
page1megaB:
		mov		WriteMemTbl + 2, 2
		mov		cx, WORD PTR _lpCartB + 2
		mov		al, MegaTblB + 2
		mov		bl, al
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl + 8 + 2, cx
		and		bx, 7
		ror		bx, 3
		mov		WORD PTR ReadMemTbl + 8 + 0, bx
		mov		cx, WORD PTR _lpCartB + 2
		mov		al, MegaTblB + 3
		mov		bl, al
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl + 8 + 6, cx
		and		bx, 7
		ror		bx, 3
		mov		WORD PTR ReadMemTbl + 8 + 4, bx
page2:
		mov		bl, dh
		shr		bx, 2
		and		bx, 1100b
		mov		eax, _MemTbl+32[bx]
		mov		ecx, eax
		shr		ecx, 16
		jcxz		page2megaA
		cmp		cx, 2
		je		SHORT page2megaA
		cmp		cx, 1
		je		SHORT page2megaB
		shr		bx, 2
		cmp		_ROMTbl+8[bx], 0
		jz		$+4
		sub		cx, cx
		mov		ReadMemTbl + 16, eax
		add		eax, 02000h ;
		mov		ReadMemTbl + 20, eax
		mov		WriteMemTbl + 4, cx
		jmp		short page3
page2megaA:
		inc		cx
		mov		WriteMemTbl + 4, cx
		mov		cx, WORD PTR _lpCartA + 2
		mov		al, MegaTblA + 0
		mov		bl, al
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl + 16 + 2, cx
		and		bx, 7
		ror		bx, 3
		mov		WORD PTR ReadMemTbl + 16 + 0, bx
		mov		cx, WORD PTR _lpCartA + 2
		mov		al, MegaTblA + 1
		mov		bl, al
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl + 16 + 6, cx
		and		bx, 7
		ror		bx, 3
		mov		WORD PTR ReadMemTbl + 16 + 4, bx
		jmp		short page3
page2megaB:
		mov		WriteMemTbl + 4, 2
		mov		cx, WORD PTR _lpCartB + 2
		mov		al, MegaTblB + 0
		mov		bl, al
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl + 16 + 2, cx
		and		bx, 7
		ror		bx, 3
		mov		WORD PTR ReadMemTbl + 16 + 0, bx
		mov		cx, WORD PTR _lpCartB + 2
		mov		al, MegaTblB + 1
		mov		bl, al
		and		ax, 038h
		add		cx, ax
		mov		WORD PTR ReadMemTbl + 16 + 6, cx
		and		bx, 7
		ror		bx, 3
		mov		WORD PTR ReadMemTbl + 16 + 4, bx
page3:
		mov		bl, dh
		shr		bx, 4
		and		bx, 1100b
		mov		eax, _MemTbl+3*16+[bx]
		mov		ecx, eax
		shr		ecx, 16
		shr		bx, 2
		cmp		_ROMTbl+12[bx], 0
		jz		$+4
		sub		cx, cx
		mov		ReadMemTbl + 24, eax
		add		eax, 02000h ;
		mov		ReadMemTbl + 28, eax
		mov		WriteMemTbl + 6, cx
		pop		eax
		ret
ProWritea8	ENDP

Writed0:
		mov		_regAF, ax
		push		di
		call		_Patch
		add		sp, 2
		mov       ax, _regAF
		mov		fIFF, 0
		ret

WriteIO		ENDP

_Reset		PROC		FAR
		sub		ax, ax
		; reset cpu
		mov		_regPC, ax
		mov		fIFF, al
		; reset PSG
		mov		_PSGReg[7], 255
		; reset vdp
		mov		IsFirst, al
		mov		WORD PTR VDPReg, ax
		mov		WORD PTR VDPReg[2], ax
		mov		WORD PTR VDPReg[4], ax
		mov		WORD PTR VDPReg[6], ax
		mov		_bScrModified, 1
		; reset MegaROM
		mov		DWORD PTR MegaTblA, 01000302h
		mov		DWORD PTR MegaTblB, 01000302h
		; reset memory map
		sub		dh, dh
		call		ProWritea8
		ret
_Reset		ENDP

_ResetMega	PROC		FAR
		; reset MegaROM
		mov		DWORD PTR MegaTblA, 01000302h
		mov		DWORD PTR MegaTblB, 01000302h
		; reset memory map
		mov		dh, PPIregA
		call		ProWritea8
		ret
_ResetMega	ENDP

			END
