// document.c -- Document implemention file MSX for Windows
#include <windows.h>
#include <commdlg.h>
#include <stdlib.h>
#include <string.h>
#include "msx.h"
#include "resource.h"
#include "msxcore.h"
#include "document.h"
#include "dialogs.h"
#include "assert.h"

extern HINSTANCE	g_hInstance ;
extern HPALETTE	g_hpalScreen ;
extern BYTE		g_vkTbl[] ;
extern const char	g_szAppName[] ;
extern HWND		g_hwndMain ;
extern UINT		g_uState ;
extern BOOL		g_bDriveA, g_bDriveB ;

const FILESETTINGS DefSet = { 0, 1, 5, 
	0, 0, 0, 0, 		36, 219, 36, 0, 
	109, 255, 109, 0, 	36, 36, 255, 0, 
	73, 109, 255, 0, 	182, 36, 36, 0, 
	73, 219, 255, 0, 	255, 36, 36, 0, 
	255, 109, 109, 0, 	219, 219, 36, 0, 
	219, 219, 146, 0, 	36, 146, 36, 0, 
	219, 73, 182, 0, 	182, 182, 182, 0, 
	255, 255, 255, 0, 
	VK_NEXT, VK_PRIOR, VK_END, VK_F8, 0, 0, 0, 1, 
	1, 0, 0, 1, 0, 0 } ;

FILESETTINGS		g_fileset ;
BOOL				g_bNeedSave = FALSE ;
char				g_szRecentFile[4][_MAX_PATH], g_szFileName[_MAX_PATH], 
				g_szFileTitle[_MAX_PATH], g_szUntitled[] = "[untitled]", 
				g_szCartAFile[_MAX_PATH], g_szCartBFile[_MAX_PATH], 
				g_szDiskAFile[_MAX_PATH], g_szDiskBFile[_MAX_PATH], 
				BASED_CODE g_szSetupFilter[] = "Setup Files (*.msx)\0*.msx\0All Files (*.*)\0*.*\0", 
				BASED_CODE g_szSetupDefExt[] = "msx" ;

BOOL SetFile (HWND hwnd, const FILESETTINGS *pflstNew, const char *szCartA, const char *szCartB)
	{
	int		n ;
	
	n = 0 ;
	
	if (pflstNew != NULL)
		{
		if (g_fileset.nDisk != pflstNew->nDisk)
			{
			if (g_uState >= 1)
				{
				n = MessageID (hwnd, IDS_RESTART, MB_OKCANCEL | MB_ICONQUESTION) ;
				if (n == IDCANCEL)
					return FALSE ;
				}
			}
		
		g_fileset = *pflstNew ;
		
		g_vkTbl[3] = g_fileset.vkCode ;
		g_vkTbl[5] = g_fileset.vkGraph ;
		g_vkTbl[9] = g_fileset.vkSelect ;
		g_vkTbl[11] = g_fileset.vkStop ;
		
		SetView () ;
		
		CreateIdentityPalette (&g_fileset.ape[0]) ;
		}
	
	if (szCartA != NULL)
		{
		assert (szCartB != NULL) ;
		
		if (g_uState >= 1 && (strcmp (g_szCartAFile, szCartA) || strcmp (g_szCartBFile, szCartB) ) && !n)
			{
			n = MessageID (hwnd, IDS_RESTART, MB_YESNOCANCEL | MB_ICONQUESTION) ;
			if (n == IDCANCEL)
				return FALSE ;
			}
		}
	else	assert (szCartB == NULL) ;
	
	if (szCartA != NULL)
		{
		strcpy (g_szCartAFile, szCartA) ;
		strcpy (g_szCartBFile, szCartB) ;
		}
	
	if (n == IDYES || n == IDOK)
		{
		StopEmulator () ;
		StartEmulator () ;
		InvalidateRect (g_hwndMain, NULL, FALSE) ;
		}
	else if (n == IDNO)
		SetCarts () ;
	
	return TRUE ;
	}

static void NEAR AddToRecentList ()
	{
	int  i ;
	
	for (i=0;i<3;i++)
		{
		if (!strcmp (g_szFileName, g_szRecentFile[i]) )
			break ;
		}
	
	for (;i>0;i--)
		{
		strcpy (g_szRecentFile[i], g_szRecentFile[i - 1]) ;
		}
	
	strcpy (g_szRecentFile[0], g_szFileName) ;
	}

BOOL FileLoadDlg (LPSTR lpszFile)
	{
	OPENFILENAME	ofn ;
	
	lpszFile[0] = '\0' ;
	
	memset (&ofn, 0, sizeof (OPENFILENAME) ) ;
	ofn.lStructSize = sizeof (OPENFILENAME) ;
	ofn.hwndOwner   = g_hwndMain ;
	ofn.lpstrFilter = g_szSetupFilter ;
	ofn.lpstrFile   = lpszFile ;
	ofn.nMaxFile    = _MAX_PATH ;
	ofn.Flags       = OFN_FILEMUSTEXIST | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY ;
	ofn.lpstrDefExt = g_szSetupDefExt ;
	
	DeActivate () ;
	
	return GetOpenFileName (&ofn) ;
	}

BOOL FileSaveDlg (LPSTR lpszFile)
	{
	OPENFILENAME	ofn ;
	
	_fstrcpy (lpszFile, g_szFileName) ;
	
	memset (&ofn, 0, sizeof (OPENFILENAME) ) ;
	ofn.lStructSize = sizeof (OPENFILENAME) ;
	ofn.hwndOwner   = g_hwndMain ;
	ofn.lpstrFilter = g_szSetupFilter ;
	ofn.lpstrFile   = lpszFile ;
	ofn.nMaxFile    = _MAX_PATH ;
	ofn.Flags       = OFN_FILEMUSTEXIST | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY ;
	ofn.lpstrDefExt = g_szSetupDefExt ;
	
	DeActivate () ;
	
	return GetSaveFileName (&ofn) ;
	}

#define HDRLEN 10
static const char BASED_CODE 	szHeader[HDRLEN] = "MSXSETUP\1\0" ;

static void NEAR FileErr (UINT nErr, LPSTR lpszFile)
	{
	char		szBuf[256], szBuf2[_MAX_PATH] ;
	
	LoadString (g_hInstance, nErr, szBuf, 256) ;
	wsprintf (szBuf2, szBuf, lpszFile) ;
	MessageBox (g_hwndMain, szBuf2, g_szAppName, MB_ICONEXCLAMATION) ;
	}

BOOL FileLoad (LPSTR lpszFile)
	{
	HFILE		hFile ;
	char			szBuf[HDRLEN], szCartAFile[_MAX_PATH], szCartBFile[_MAX_PATH], 
				szDiskAFile[_MAX_PATH], szDiskBFile[_MAX_PATH] ;
	FILESETTINGS	newset ;
	OFSTRUCT		of ;
	WORD			w ;
	
	hFile = OpenFile (lpszFile, &of, OF_READ) ;
	if (HFILE_ERROR == hFile)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
			case 0x0003:
				FileErr (IDS_FILEREADPATH, lpszFile) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEREADACCESS, lpszFile) ;
				break ;
			
			default:
				FileErr (IDS_FILEREADUNEXPECT, lpszFile) ;
				break ;
			}
		
		return FALSE ;
		}
	
	// check if correct format
	if (_lread (hFile, szBuf, HDRLEN) != HDRLEN || 
		_fstrncmp (szBuf, szHeader, HDRLEN) )
		{
		_lclose (hFile) ;
			
		FileErr (IDS_FILESETUP, lpszFile) ;
			
		return FALSE ;
		}
	
	// load the stuff
	if (_lread (hFile, &newset, sizeof (FILESETTINGS) ) != sizeof (FILESETTINGS) || 
		_lread (hFile, &w, 2) != 2 || 
		_lread (hFile, szCartAFile, w) != w || 
		_lread (hFile, &w, 2) != 2 || 
		_lread (hFile, szCartBFile, w) != w || 
		_lread (hFile, &w, 2) != 2 || 
		_lread (hFile, szDiskAFile, w) != w || 
		_lread (hFile, &w, 2) != 2 || 
		_lread (hFile, szDiskBFile, w) != w)
		{
		_lclose (hFile) ;
			
		FileErr (IDS_FILESETUP, lpszFile) ;
			
		return FALSE ;
		}
	
	_lclose (hFile) ;
	
	if (SetFile (g_hwndMain, &newset, szCartAFile, szCartBFile) )
		{
		strcpy (g_szDiskAFile, szDiskAFile) ;
		strcpy (g_szDiskBFile, szDiskBFile) ;
		
		g_bNeedSave = FALSE ;
		
		_fstrcpy (g_szFileName, lpszFile) ;
		AnsiUpper (g_szFileName) ;
		GetFileTitle (g_szFileName, g_szFileTitle, _MAX_FNAME + _MAX_EXT) ;
		
		AddToRecentList () ;
		
		return TRUE ;
		}
	
	return FALSE ;
	}

BOOL FileSave (LPSTR lpszFile)
	{
	HFILE	hFile ;
	WORD		w1, w2, w3, w4 ;
	OFSTRUCT	of ;
	
	hFile = OpenFile (lpszFile, &of, OF_CREATE | OF_WRITE) ;
	if (HFILE_ERROR == hFile)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
			case 0x0003:
				FileErr (IDS_FILEWRITEPATH, lpszFile) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEWRITEACCESS, lpszFile) ;
				break ;
			
			default:
				FileErr (IDS_FILEWRITEUNEXPECT, lpszFile) ;
				break ;
			}
		
		return FALSE ;
		}
	
	w1 = strlen (g_szCartAFile) + 1 ;
	w2 = strlen (g_szCartBFile) + 1 ;
	w3 = strlen (g_szDiskAFile) + 1 ;
	w4 = strlen (g_szDiskBFile) + 1 ;
	if (_lwrite (hFile, szHeader, HDRLEN) != HDRLEN || 
		_lwrite (hFile, (PBYTE) &g_fileset, sizeof (FILESETTINGS) ) != sizeof (FILESETTINGS) || 
		_lwrite (hFile, &w1, 2) != 2 || 
		_lwrite (hFile, g_szCartAFile, w1) != w1 || 
		_lwrite (hFile, &w2, 2) != 2 || 
		_lwrite (hFile, g_szCartBFile, w2) != w2 ||
		_lwrite (hFile, &w3, 2) != 2 || 
		_lwrite (hFile, g_szDiskAFile, w3) != w3 || 
		_lwrite (hFile, &w4, 2) != 2 || 
		_lwrite (hFile, g_szDiskBFile, w4) != w4)
		{
		_lclose (hFile) ;
		
		// delete the crap created
		OpenFile (lpszFile, NULL, OF_DELETE) ;
		
		FileErr (IDS_FILEWRITEFULL, lpszFile) ;
		
		return FALSE ;
		}
	
	_lclose (hFile) ;
	g_bNeedSave = FALSE ;
	_fstrcpy (g_szFileName, lpszFile) ;
	AnsiUpper (g_szFileName) ;
	GetFileTitle (g_szFileName, g_szFileTitle, _MAX_FNAME + _MAX_EXT) ;
	
	AddToRecentList () ;
	
	return TRUE ;
	}

void FileNew ()
	{
	if (SetFile (g_hwndMain, &DefSet, "", "") )
		{
		if (g_bDriveA || g_bDriveB)
			{
			g_fileset.nDrvA = g_bDriveB ? 2 : 1 ;
			}
		
		g_bNeedSave = FALSE ;
		g_szFileName[0] = g_szFileTitle[0] = '\0' ;
		g_szDiskAFile[0] = g_szDiskBFile[0] = '\0' ;
		}
	}

BOOL AskSave ()
	{
	char			szBuf[256], szText[256] ;
	extern BOOL	g_bAskSave ;
	
	if (g_bNeedSave && g_bAskSave)
		{
		LoadString (g_hInstance, IDS_MSGSAVE, szBuf, 256) ;
		
		wsprintf (szText, szBuf, (LPSTR) (g_szFileTitle[0] ? g_szFileTitle : g_szUntitled) ) ;
		
		DeActivate () ;
		switch (MessageBox (g_hwndMain, szText, g_szAppName, MB_YESNOCANCEL | MB_ICONQUESTION) )
			{		
			case IDCANCEL:
				return FALSE ;
			
			case IDYES:
				if (g_szFileName[0] || FileSaveDlg (g_szFileName) )
					return FileSave (g_szFileName) ;
			}
		}
	
	return TRUE ;
	}
